--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

ISStartChainsawAction = ISBaseTimedAction:derive("ISStartChainsawAction");

function ISStartChainsawAction:isValid()
	self.ModData = self.chainsaw:getModData();
	return self.chainsaw ~= nil and self.character:isEquipped(chainsaw) and self.ModData.FuelAmt > 0;
end

function ISStartChainsawAction:update()
	self.chainsaw:setJobDelta(self:getJobDelta());
end

function ISStartChainsawAction:start()
	self.chainsaw:setJobType(getText("ContextMenu_StartChainsaw"));
	self.chainsaw:setJobDelta(0.0);
end

function ISStartChainsawAction:stop()
	ISBaseTimedAction.stop(self);
    self.chainsaw:setJobDelta(0.0);
end

function ISStartChainsawAction:perform()
	self.character:playSound("cs_start");
	addSound(self.character, self.character:getX(), self.character:getY(), self.character:getZ(), 30, 1);
	
	-- Values for Chainsaw ON		
	self.ModData.Run = true;
	self.chainsaw:setJobDelta(0.0);	
	
    -- needed to remove from queue / start next
	ISBaseTimedAction.perform(self);
end

function ISStartChainsawAction:new(character, chainsaw, time)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o.character = character;
	o.stopOnWalk = false;
	o.stopOnRun = true;
	o.maxTime = time;
	-- custom fields
	o.chainsaw = chainsaw;
	return o;
end